package gov.va.vamf.scheduling.varutility.resources;

import gov.va.vamf.scheduling.varutility.clientapi.MobileHealthClientTestVersion;
import gov.va.vamf.scheduling.varutility.domain.CoreSetting;
import gov.va.vamf.scheduling.varutility.domain.CoreSettings;
import gov.va.vamf.scheduling.varutility.domain.DirectBookingEligibilityCriteria;
import gov.va.vamf.scheduling.varutility.testutility.IntegrationTestConfiguration;
import gov.va.vamf.scheduling.varutility.testutility.TestHelper;
import org.junit.*;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import java.net.URI;

public class VarUtilityResourceTest {

	private static MobileHealthClientTestVersion client;
	private static Client jerseyClient;
	private static String TEST_SITE_CODE = "test-site-code";

	@BeforeClass
	public static void startup() {
        client = TestHelper.createProviderClient();
		jerseyClient = client.getJerseyClient();
	}

	@AfterClass
	public static void destroy() {
		if (client != null) {
            client.getJerseyClient().close();
            client = null;
		}
	}

	@Before
	public void testPost() {
		DirectBookingEligibilityCriteria postPayload = createCriteriaPayload(TEST_SITE_CODE);

		DirectBookingEligibilityCriteria newCriteria = jerseyClient.target(getResourceUri(TEST_SITE_CODE, ""))
			.request().accept(MediaType.APPLICATION_JSON).post(Entity.entity(postPayload, MediaType.APPLICATION_JSON), DirectBookingEligibilityCriteria.class);

		Assert.assertTrue(newCriteria != null);
		Assert.assertEquals(TEST_SITE_CODE, newCriteria.getId());
	}

	private DirectBookingEligibilityCriteria createCriteriaPayload(String siteCode) {
		DirectBookingEligibilityCriteria criteria = new DirectBookingEligibilityCriteria();

		CoreSettings cs = new CoreSettings();
		cs.add(new CoreSetting("323", "PRIMARY CARE", "", null, null, true, 1, 1));
		cs.add(new CoreSetting("203", "AUDIOLOGY", "", null, null, true, 2, 2));
		cs.add(new CoreSetting("408", "OPTOMETRY", "", null, null, true, 2, 2));
		cs.add(new CoreSetting("502", "OUTPATIENT MENTAL HEALTH", "", null, null, true, 3, 3));

		criteria.setId(siteCode);
		criteria.setCoreSettings(cs);

		return criteria;
	}

	@Test
	public void testFetch() {
		DirectBookingEligibilityCriteria criteria = jerseyClient.target(getResourceUri(TEST_SITE_CODE, ""))
			.request().accept(MediaType.APPLICATION_JSON).get(DirectBookingEligibilityCriteria.class);

		Assert.assertTrue(criteria != null);
		Assert.assertEquals(TEST_SITE_CODE, criteria.getId());
	}

	@Test
	public void testUpdate() {
		DirectBookingEligibilityCriteria criteria = jerseyClient.target(getResourceUri(TEST_SITE_CODE, ""))
				.request().accept(MediaType.APPLICATION_JSON).get(DirectBookingEligibilityCriteria.class);

		Assert.assertTrue(criteria != null);
		Assert.assertEquals(TEST_SITE_CODE, criteria.getId());

		criteria = jerseyClient.target(getResourceUri(TEST_SITE_CODE, TEST_SITE_CODE))
				.request().accept(MediaType.APPLICATION_JSON).put(Entity.entity(criteria, MediaType.APPLICATION_JSON), DirectBookingEligibilityCriteria.class);

		Assert.assertTrue(criteria != null);
		Assert.assertEquals(TEST_SITE_CODE, criteria.getId());
	}

	private static URI getResourceUri(String siteCode, String id) {
		String uriFormat = String.format("%s/direct-booking-eligibility-criteria/site/%s" + (id.length() != 0 ? "/id/%s" : "%s"),
			IntegrationTestConfiguration.getServerBaseUri(), siteCode, id);

		return UriBuilder.fromUri(uriFormat).build();
	}
}
